@extends('layouts.app')

@section('title', 'Pengaturan - Admin IDN Menulis')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Pengaturan</h1>
        <p class="text-gray-600 mt-1">Konfigurasi platform IDN Menulis</p>
    </div>

    <div class="space-y-6">
        <!-- General Settings -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Pengaturan Umum</h2>
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nama Platform</label>
                    <input type="text" value="IDN Menulis" disabled
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg bg-gray-50">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Deskripsi</label>
                    <textarea disabled rows="2"
                              class="w-full px-4 py-3 border border-gray-300 rounded-lg bg-gray-50">Platform literasi digital untuk siswa Indonesia</textarea>
                </div>
            </div>
        </div>

        <!-- Article Settings -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Pengaturan Artikel</h2>
            <div class="space-y-4">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="font-medium text-gray-900">Perlu Persetujuan Guru</p>
                        <p class="text-sm text-gray-500">Artikel siswa harus disetujui guru sebelum dipublikasikan</p>
                    </div>
                    <span class="bg-green-100 text-green-700 px-3 py-1 rounded text-sm">Aktif</span>
                </div>
                <div class="flex items-center justify-between">
                    <div>
                        <p class="font-medium text-gray-900">Moderasi Komentar</p>
                        <p class="text-sm text-gray-500">Komentar harus dimoderasi sebelum ditampilkan</p>
                    </div>
                    <span class="bg-green-100 text-green-700 px-3 py-1 rounded text-sm">Aktif</span>
                </div>
            </div>
        </div>

        <!-- System Info -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Informasi Sistem</h2>
            <div class="grid grid-cols-2 gap-4 text-sm">
                <div>
                    <p class="text-gray-500">Laravel Version</p>
                    <p class="text-gray-900">{{ app()->version() }}</p>
                </div>
                <div>
                    <p class="text-gray-500">PHP Version</p>
                    <p class="text-gray-900">{{ phpversion() }}</p>
                </div>
                <div>
                    <p class="text-gray-500">Environment</p>
                    <p class="text-gray-900">{{ app()->environment() }}</p>
                </div>
                <div>
                    <p class="text-gray-500">Debug Mode</p>
                    <p class="text-gray-900">{{ config('app.debug') ? 'On' : 'Off' }}</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
