<?php $__env->startSection('title', 'Bookmark Saya - IDN Menulis'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Bookmark Saya</h1>
        <p class="text-gray-600 mt-1">Artikel yang telah Anda simpan</p>
    </div>

    <div id="bookmarks-container" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <article id="bookmark-<?php echo e($article->id); ?>" class="bg-white rounded-lg shadow overflow-hidden hover:shadow-lg transition">
                <?php if($article->featured_image): ?>
                    <img src="<?php echo e(Storage::url($article->featured_image)); ?>" alt="<?php echo e($article->title); ?>"
                         class="w-full h-48 object-cover">
                <?php else: ?>
                    <div class="w-full h-48 bg-gradient-to-br from-blue-400 to-purple-400"></div>
                <?php endif; ?>
                <div class="p-6">
                    <div class="flex gap-2 mb-2">
                        <span class="text-xs bg-blue-100 text-blue-700 px-2 py-1 rounded"><?php echo e($article->category->name ?? 'Uncategorized'); ?></span>
                    </div>
                    <h2 class="text-xl font-bold text-gray-900 mb-2">
                        <a href="<?php echo e(route('articles.show', $article)); ?>" class="hover:text-blue-600">
                            <?php echo e(Str::limit($article->title, 60)); ?>

                        </a>
                    </h2>
                    <p class="text-gray-600 text-sm mb-4">
                        <?php echo e(Str::limit($article->excerpt ?? strip_tags($article->content), 100)); ?>

                    </p>
                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-500"><?php echo e($article->user->full_name ?? 'Unknown'); ?></span>
                        <button type="button"
                                onclick="removeBookmark(<?php echo e($article->id); ?>, '<?php echo e($article->slug); ?>')"
                                class="text-red-600 hover:text-red-700 text-sm font-medium flex items-center gap-1">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                            </svg>
                            Hapus Bookmark
                        </button>
                    </div>
                </div>
            </article>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div id="empty-state" class="col-span-3 py-12 text-center text-gray-500">
                <p>Belum ada artikel yang di-bookmark.</p>
                <a href="<?php echo e(route('home')); ?>" class="text-blue-600 hover:underline mt-2 inline-block">Jelajahi artikel</a>
            </div>
        <?php endif; ?>
    </div>

    <?php if($articles->hasPages()): ?>
        <div class="mt-8">
            <?php echo e($articles->links()); ?>

        </div>
    <?php endif; ?>
</div>

<script>
async function removeBookmark(articleId, articleSlug) {
    if (!confirm('Hapus artikel ini dari bookmark?')) return;

    try {
        const response = await fetch(`/artikel/${articleSlug}/bookmark`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            }
        });

        const data = await response.json();

        if (data.success && !data.bookmarked) {
            // Remove the article card with animation
            const card = document.getElementById(`bookmark-${articleId}`);
            if (card) {
                card.style.transition = 'all 0.3s ease-out';
                card.style.opacity = '0';
                card.style.transform = 'scale(0.95)';

                setTimeout(() => {
                    card.remove();

                    // Check if no more bookmarks
                    const container = document.getElementById('bookmarks-container');
                    if (container.querySelectorAll('article').length === 0) {
                        container.innerHTML = `
                            <div class="col-span-3 py-12 text-center text-gray-500">
                                <p>Belum ada artikel yang di-bookmark.</p>
                                <a href="/" class="text-blue-600 hover:underline mt-2 inline-block">Jelajahi artikel</a>
                            </div>
                        `;
                    }
                }, 300);
            }
        } else {
            alert(data.message || 'Gagal menghapus bookmark.');
        }
    } catch (error) {
        console.error('Error:', error);
        alert('Terjadi kesalahan. Silakan coba lagi.');
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\IDNMenulis\resources\views/bookmarks/index.blade.php ENDPATH**/ ?>