<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <!-- CSRF Token - Required for AJAX requests -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Primary Meta Tags -->
    <title><?php echo $__env->yieldContent('title', 'IDN Menulis - Platform Menulis Indonesia'); ?></title>
    <meta name="title" content="<?php echo $__env->yieldContent('meta_title', 'IDN Menulis - Platform Menulis Indonesia'); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Platform menulis dan berbagi cerita terbaik di Indonesia. Tulis, baca, dan bagikan karya tulismu.'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', 'menulis, blog, artikel, cerita, indonesia, penulis'); ?>">
    <meta name="author" content="IDN Menulis">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="<?php echo e(url()->current()); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="<?php echo $__env->yieldContent('og_type', 'website'); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo $__env->yieldContent('meta_title', 'IDN Menulis'); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('meta_description'); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('og_image', asset('images/og-default.jpg')); ?>">
    <meta property="og:locale" content="id_ID">
    <meta property="og:site_name" content="IDN Menulis">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta name="twitter:title" content="<?php echo $__env->yieldContent('meta_title', 'IDN Menulis'); ?>">
    <meta name="twitter:description" content="<?php echo $__env->yieldContent('meta_description'); ?>">
    <meta name="twitter:image" content="<?php echo $__env->yieldContent('og_image', asset('images/og-default.jpg')); ?>">

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(asset('apple-touch-icon.png')); ?>">

    <!-- Preconnect untuk performa -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdfa',
                            100: '#ccfbf1',
                            200: '#99f6e4',
                            300: '#5eead4',
                            400: '#2dd4bf',
                            500: '#14b8a6',
                            600: '#0d9488',
                            700: '#0f766e',
                            800: '#115e59',
                            900: '#134e4a',
                        },
                        accent: {
                            50: '#fff7ed',
                            100: '#ffedd5',
                            200: '#fed7aa',
                            300: '#fdba74',
                            400: '#fb923c',
                            500: '#f97316',
                            600: '#ea580c',
                            700: '#c2410c',
                            800: '#9a3412',
                            900: '#7c2d12',
                        }
                    },
                    fontFamily: {
                        'sans': ['Inter', 'sans-serif'],
                        'display': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>

    <!-- Alpine.js via CDN -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Swiper.js for Carousel -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <!-- TinyMCE Scripts -->
    <script src="https://cdn.tiny.cloud/1/<?php echo e(config('services.tinymce.api_key', '')); ?>/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <!-- Custom Styles -->
    <style>
        body { font-family: 'Inter', sans-serif; }
        h1, h2, h3, h4, h5, h6 { font-family: 'Poppins', sans-serif; }

        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 8px; height: 8px; }
        ::-webkit-scrollbar-track { background: #f1f5f9; }
        ::-webkit-scrollbar-thumb { background: #14b8a6; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #0d9488; }

        /* Smooth scroll */
        html { scroll-behavior: smooth; }

        /* Line clamp utilities */
        .line-clamp-2 { display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
        .line-clamp-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }

        /* Swiper custom styles */
        .swiper-pagination-bullet-active { background: #14b8a6 !important; }
        .swiper-button-next, .swiper-button-prev { color: #14b8a6 !important; }

        /* Gradient text */
        .gradient-text {
            background: linear-gradient(135deg, #14b8a6 0%, #0d9488 50%, #f97316 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Card hover effects */
        .card-hover {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        /* Image zoom on hover */
        .img-zoom { transition: transform 0.5s ease; }
        .group:hover .img-zoom { transform: scale(1.05); }
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body class="antialiased bg-slate-50 text-gray-900">
    <div id="app" x-data="{ mobileMenu: false }">
        <!-- Navigation -->
        <?php echo $__env->make('components.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Flash Messages -->
        <?php if($message = Session::get('success')): ?>
            <div x-data="{ show: true }" x-init="setTimeout(() => show = false, 5000)"
                 x-show="show" x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform translate-x-8"
                 x-transition:enter-end="opacity-100 transform translate-x-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                 class="fixed top-20 right-4 bg-primary-500 text-white px-6 py-4 rounded-xl shadow-2xl z-50 flex items-center gap-3">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                </svg>
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <?php if($message = Session::get('error')): ?>
            <div x-data="{ show: true }" x-init="setTimeout(() => show = false, 5000)"
                 x-show="show" x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform translate-x-8"
                 x-transition:enter-end="opacity-100 transform translate-x-0"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                 class="fixed top-20 right-4 bg-red-500 text-white px-6 py-4 rounded-xl shadow-2xl z-50 flex items-center gap-3">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
                <?php echo e($message); ?>

            </div>
        <?php endif; ?>

        <!-- Main Content -->
        <main>
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Footer -->
        <?php echo $__env->make('components.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <!-- Security: CSRF Token Setup for AJAX -->
    <script>
        // Setup CSRF token for all AJAX requests
        window.Laravel = <?php echo json_encode(['csrfToken' => csrf_token()]); ?>;

        // Axios CSRF setup (if using Axios)
        if (typeof axios !== 'undefined') {
            axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
        }

        // Fetch API CSRF wrapper
        window.secureFetch = function(url, options = {}) {
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

            options.headers = {
                ...options.headers,
                'X-CSRF-TOKEN': csrfToken,
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
            };

            if (options.body && typeof options.body === 'object' && !(options.body instanceof FormData)) {
                options.headers['Content-Type'] = 'application/json';
                options.body = JSON.stringify(options.body);
            }

            return fetch(url, options);
        };

        // Frame busting protection
        if (window.top !== window.self) {
            // Only allow framing from same origin
            try {
                if (window.top.location.host !== window.self.location.host) {
                    window.top.location = window.self.location;
                }
            } catch (e) {
                // Cross-origin frame, break out
                window.top.location = window.self.location;
            }
        }

        // Prevent sensitive data in localStorage
        const sensitiveKeys = ['password', 'token', 'secret', 'api_key'];
        const originalSetItem = localStorage.setItem;
        localStorage.setItem = function(key, value) {
            const lowerKey = key.toLowerCase();
            if (sensitiveKeys.some(sensitive => lowerKey.includes(sensitive))) {
                console.warn('Security: Storing sensitive data in localStorage is not recommended');
            }
            return originalSetItem.apply(this, arguments);
        };

        // Auto-publish scheduled articles (polling every 30 seconds)
        (function publishScheduledArticles() {
            const csrfToken = document.querySelector('meta[name="csrf-token"]');
            if (!csrfToken) return;

            setInterval(async () => {
                try {
                    await fetch('/api/publish-scheduled', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken.getAttribute('content'),
                            'Accept': 'application/json'
                        }
                    });
                } catch (e) {
                    // Silently fail - this is a background task
                }
            }, 30000); // Every 30 seconds
        })();
    </script>

    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\IDNMenulis\resources\views/layouts/app.blade.php ENDPATH**/ ?>